<?php
// Mengizinkan permintaan dari domain mana pun (penting untuk WebView)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");

// Direktori untuk menyimpan file sementara
$uploadDir = 'uploads/';

// Buat direktori jika belum ada
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// --- Logika untuk membersihkan file lama ---
// File yang lebih tua dari 30 detik akan dihapus
$files = glob($uploadDir . '*');
$now   = time();

foreach ($files as $file) {
    if (is_file($file)) {
        if ($now - filemtime($file) >= 30) { // 30 detik
            unlink($file);
        }
    }
}
// --- Akhir logika pembersihan ---


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $tempName = $_FILES['file']['tmp_name'];
        
        // Buat nama file yang unik
        $originalName = $_FILES['file']['name'];
        $fileExtension = pathinfo($originalName, PATHINFO_EXTENSION);
        $uniqueName = uniqid('rencana-', true) . '.' . $fileExtension;
        
        $destination = $uploadDir . $uniqueName;

        // Pindahkan file yang diunggah ke direktori tujuan
        if (move_uploaded_file($tempName, $destination)) {
            // Dapatkan URL dasar dari server
            $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
            $host = $_SERVER['HTTP_HOST'];
            $path = dirname($_SERVER['PHP_SELF']);
            $downloadUrl = $protocol . "://" . $host . $path . "/" . $destination;

            // Kirim kembali URL unduhan dalam format JSON
            header('Content-Type: application/json');
            echo json_encode(['downloadUrl' => $downloadUrl]);
        } else {
            http_response_code(500);
            echo json_encode(['error' => 'Gagal menyimpan file.']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Tidak ada file yang diunggah atau terjadi error.']);
    }
} else {
    // Menangani permintaan GET hanya untuk konfirmasi
    echo "Server PHP aktif. Endpoint ini siap menerima file melalui metode POST.";
}
?>
